import Adafruit_DHT
import time
import datetime
from datetime import date
from openpyxl import load_workbook

# DHT11 sensor selected
sensor = Adafruit_DHT.DHT11

# DHT sensor pin connected to GPIO 4
sensor_pin = 4

# create a variable to control the while loop
running = True

# Load the workbook and select the sheet
wb = load_workbook('/home/pi/dht11_excel/weather.xlsx')
sheet = wb['Sheet1']

# loop forever
while running:

    try:
        # read the humidity and temperature
        humidity, temperature = Adafruit_DHT.read_retry(sensor, sensor_pin)

        # The line below converts to Fahrenheit
        temp_f = temperature * 9/5.0 + 32
        
        today = date.today()
        now = datetime.datetime.now().time()

        if humidity is not None and temperature is not None:

            #print temperature and humidity
            print('Temp C = ' + str(temperature) +','+ 'Temp F = ' + str(temp_f) +',' + 'Humidity = ' + str(humidity))
            
            # update data to excel sheet
            row = (today, now, temperature, temp_f, humidity)
            sheet.append(row)
            time.sleep(1)

            # The workbook is saved!
            wb.save('/home/pi/dht11_excel/weather.xlsx')

        else:
            print('Failed to get reading. Try again!')
            time.sleep(1)

    except KeyboardInterrupt:
        print ('Goodbye!')
        running = False